   ; B_SPLINES: compute the 1-D observation matrix to determine the
   ;	coefficients of an interpolating spline in the B-splines
   ;	representation.
   ;	Auxiliary function of SPLINE_COEFF and SPLINE_INTERP.

   ; INPUT
   ;	points: set of observation points
   ;	npoints: number of points
   ;	knots: knots of the spline
   ;	degree: spline degree
   ;	[/BOUNDS]: option used by SPLINE_INTERP to compute the
   ;		observation matrix
   ;	[/FULL]: the observation matrix is stored as a npoints * npoints
   ;		array; otherwise it is stored as a (degree + 1) * npoints array
   ; OUTPUT
   ;	a: observation matrix
   ;	npt: vector of subscripts defining the relative position of the
   ;		observation points with respect to the knots of the spline





   ; BSPL: given a set of knots k and a point x, with k[s] <= x < k[s+1],
   ;	compute the (d + 1) non-zero B-splines of degree d at x, using
   ;	the recurrence relations of de Boor and Cox.

   FUNCTION bspl, k, d, x, s

	v = fltarr( d + 1 )  &  aux = fltarr( d )
	v[0] = 1
	for  j = 1, d  do begin
	   aux[0:j-1] = v[0:j-1]  &  v[0] = 0
	   for  i = 1, j  do begin
	      si = s + i  &  sj = si - j
	      f = aux[i-1] / ( k[si] - k[sj] )
	      v[i-1] = v[i-1] + f * ( k[si] - x )
	      v[i] = f * ( x - k[sj] )
	   endfor
	endfor
	return, v
   end


   PRO b_splines, points, knots, degree, a, npt, $
   				  BOUNDS = chk_bounds, FULL = full

	npoints = n_elements( points )  &  nk = n_elements( knots )
	if  keyword_set( full )  then $
	   a = fltarr( nk - degree - 1, npoints )  else $
	   a = fltarr( degree + 1, npoints )
	npt = lonarr( npoints )
	l = degree  &  r = l + 1  &  num = 0
	for  n = 0L, npoints - 1  do begin
	   point = points[n]
	   if  keyword_set( chk_bounds )  then $
	      point = ( point > knots[degree] ) < knots[nk-degree-1]
	   while  point ge knots[r] and l lt nk - degree - 2  do begin
	      l = r  &  r = l + 1  &  num = num + 1
	   endwhile
	   npt[n] = num
	   ; knots[degree + npt[n]] <= points[n] < knots[degree + npt[n] + 1]
	   b = bspl( knots, degree, point, l )
	   if  keyword_set( full )  then  a[num,n] = b  else  a[*,n] = b
	endfor
	return
   end
