   ; BACKGROUND_NOISE: very rough estimate of the background noise
   ; standard deviation.

   ; ALGORITHM DESCRIPTION: the median smoothed image is subtracted and
   ; the standard deviation of the residual image is computed. Pixels
   ; having an absolute value greater than a fixed threshold * the standard
   ; deviation (outliers) are rejected. The standard deviation is computed
   ; again and assumed as a (very rough) estimate of the background noise.

   ; INPUT
   ;	image
   ;	[BOX = ]: box size to compute median (default = 3 pixels)
   ;	[BKG_N_STD = ]: relative threshold to reject outliers (default = 3)
   ; OUTPUT
   ;	Return an estimate of the background noise standard deviation

   FUNCTION background_noise, image, BOX = box, BKG_N_STD = n_std

	if  n_elements( box ) eq 0  then  box = 3
	if  n_elements( n_std ) eq 0  then  n_std = 3
	sub = image - median_filter( image, box )
	std = sqrt( ( moment( sub ) )[1] )
	w = where( abs( sub ) lt n_std * std, count )
	if  count eq 0  then  return, 0
	return, sqrt( (moment( sub[w] ))[1] )
   end
