   ; BACKGROUND_NOISE: compute the standard deviation of the difference
   ;	between a given image and its median filtered version.

   ; INPUT
   ;	image
   ;	[BOX = ]: box size to compute median (default = 3 pixels)
   ;	[/EXCLUDE]: if set, the statistics are performed over the
   ;		median-subtracted image regions with pixel intensities in
   ;		the range [-|min|,+|min|], where min is the (negative)
   ;		minimum of the residual image
   ; OUTPUT
   ;	Return an estimate of the background noise standard deviation

   FUNCTION background_noise_, image, BOX = box, EXCLUDE = exclude

	on_error, 1
	if  mysize( image, /N_DIM ) ne 2  then  message, 'input data error'
	if  n_elements( box ) eq 0  then  box = 3
	sub = image - median_filter( image, box )
	if  min( sub ) lt 0 and keyword_set( exclude )  then begin
	   w = where( sub le -min( sub ) )  &  sub = sub[w]
	endif
	return, sqrt( (moment( sub ))[1] )
   end
