   ; BACKGROUND_NOISE: estimate background noise.

   ; ALGORITHM DESCRIPTION
   ;	A median filter with narrow box size is applied to the input
   ;	image and the smoothed array is subtracted. The background noise
   ;	standard deviation is estimated as the RMS of the resulting array.
   ;	If the input image contains stellar peaks, a better estimate may
   ;	be obtained by excluding a small circle around each peak.

   ; INPUT
   ;	image
   ;	[BOX = ]: box size to compute median (default = 3 pixels)
   ;	[x, y]: positions of peak to be excluded
   ;	[width]: width of circular mask around each peak
   ; OUTPUT
   ;	Return an estimate of the background noise standard deviation

   FUNCTION background_noise_p, image, x, y, width, BOX = box

	on_error, 1
	if  mysize( image, /N_DIM ) ne 2  then  message, 'input data error'
	if  n_elements( box ) eq 0  then  box = 3
	sub = image - median_filter( image, box )
	if  n_elements( x ) * n_elements( y ) * n_elements( width ) ne 0 $
	then begin
	   mask = byte( image - image + 1 )
	   n_peak = n_elements( x )
	   for  n = 0, n_peak - 1  do $
	      mask = circ_mask( mask, x[n], y[n], width / 2, /INNER )
	   w = where( mask eq 1B, n )
	   if  n ne 0  then  sub = sub[w]  else  sub = [0,0]
	endif
	return, sqrt( (moment( sub ))[1] )
   end
