PRO badpix, image,niter,x,y,map=map,neg=neg,filein=filein,fileout=fileout


if N_PARAMS() LT 1 THEN begin 
	print,'SYNTAX: badpix,image,x,y'
	return
endif

if keyword_set(filein) then image=readfits(filein,h)

size=n_elements(image(0,*))

if keyword_set(map) then begin 
	where2d,(map LT 1),x,y
endif

if keyword_set(neg) then begin
	where2d,(image LT neg),x1,y1
	x=[x,x1] & y=[y,y1]
endif

datasize=size(image)

if datasize(0) EQ 2 then naxis3=0 else naxis3=datasize(3)
 
for k=0,naxis3-1 do begin
j=0
image=long(image)
while (j LT niter) do begin
for i=0,n_elements(x)-1 do begin
	
if ((x(i) GT 0) AND (x(i) LT size-1) AND (y(i) GT 0) AND (y(i) LT size-1)) then begin
image[fix(x(i)),fix(y(i)),k]=long(image[fix(x(i)-1),fix(y(i)-1),k]+image[fix(x(i)+1),fix(y(i)+1),k]+image[fix(x(i)+1),fix(y(i)),k]+image[fix(x(i)),fix(y(i)+1),k]+image[fix(x(i)-1),fix(y(i)),k]+image[fix(x(i)),fix(y(i)-1),k]+image[fix(x(i)+1),fix(y(i)-1),k]+image[fix(x(i)-1),fix(y(i)+1),k])/8.
endif	
endfor
j=j+1
endwhile
endfor

if keyword_set(filein) then begin
	if NOT keyword_set(fileout) then fileout=filein 
	writefits,fileout,image,h
endif
return

end
