   ; CENTER_IMAGE: shift a 2-D image to put its maximum
   ;	in the position (x,y).

   ; INPUT
   ;	image: image to be shifted
   ;	x, y: position of image maximum after shift
   ;	[/NO_EXTEND]: the size of the array is doubled before shifting,
   ;		to prevent overlapping errors; the shifted image is then cut
   ;		to the original size. /NO_EXTEND is to avoid array extension
   ; OUTPUT
   ;	Return the shifted image. Return the original image if it is not 2-D.

   FUNCTION center_image, image, x, y, NO_EXTEND = no_extend

	if  mysize( image, /N_DIM ) ne 2  then  return, image
	if  not keyword_set( no_extend )  then begin
	   s = mysize( image, /DIM )  &  sx = s[0]  &  sy = s[1]
	   im = extend_array( image, 2*sx, 2*sy )
	endif else  im = image
	image_max = get_max( im )
	im = shift( im, x - image_max[0], y - image_max[1] )
	if  not keyword_set( no_extend )  then  im = im[0:sx-1,0:sy-1]
	return, im
   end