   ; CENTROID: compute the centroid of a 2-D image.

   ; INPUT
   ;	image
   ; OUTPUT
   ;	Return a 2-element floating-point array, containing the
   ;	position (x,y) of the image centroid
   ;	Return a negative scalar if the input image is not 2-D

   FUNCTION centroid, image

	if  mysize( image, /N_DIM ) ne 2  then  return, -1
	s = mysize( image, /DIM )  &  sx = s[0]  &  sy = s[1]
	x = findgen( sx )  &  x_one = x - x + 1
	y = findgen( sy )  &  y_one = y - y + 1
	tot_image = total( image )

	if total(image) EQ 0 then begin
		xc=0 & yc=0
	endif else begin
	xc = total( image * ( x # y_one ) ) / tot_image
	yc = total( image * ( x_one # y ) ) / tot_image
	endelse

	return, [xc, yc]
   end
