   ; CIRC_MASK: apply a circular binary mask to a 2-D image.

   ; INPUT
   ;	image
   ;	x0, y0: center of the circular mask
   ;	r0: radius of the mask
   ;	[/INNER]: mask pixels within a distance r0 from (x,y)
   ;		(default mask pixels outside)
   ; OUTPUT
   ;	Return the masked image. Return the input image if it is not 2-D.

   FUNCTION circ_mask, image, x0, y0, r0, INNER = inner

	if  mysize( image, /N_DIM ) ne 2  then  return, image
	s = mysize( image, /DIM )  &  sx = s[0]  &  sy = s[1]
	s = lindgen( sx*sy )  &  x = s mod sx  &  y = s / sx
	r = distance( x, y, float( x0 ), float( y0 ) )
	if  keyword_set( inner )  then $
	   w = where( r le r0 )	  else $
	   w = where( r gt r0 )
	return, mask_pixels( image, w )
   end