   ; CLICK_ON_MAX: interactive selection of local maxima of a displayed
   ;	image. The window containing the image must be currently active.
   ;	Click on the desired local maxima with the left button of the mouse;
   ;	click on the right button to exit. The positional accuracy of the
   ;	click is defined by the input keyword boxsize (see below).

   ; INPUT
   ;	image: displayed image
   ;	[BOXSIZE = ]: size of box to search for a local maximum in the
   ;		neighborhood of a mouse click (default = 11)
   ;	[/MARK]: put a cross on each selected peak
   ;	[_EXTRA = ]: optional input parameters of CROSSES (if /MARK is set)
   ; OUTPUT
   ;	x, y: positions of local maxima in image coordinates

   PRO click_on_max, image, BOXSIZE = boxsize, MARK = mark, $
   					 _EXTRA = extra, x, y

	s = float( mysize( image, /DIM ) )
	ws = float( [ !D.x_size, !D.y_size ] )
	if  n_elements( boxsize ) eq 0  then  boxsize = 7
	print, 'Select peak(s) by mouse left button click'
	print, 'Push right button to exit'
	!MOUSE.button = 1
	cursor, x_click, y_click, /NORMAL, /DOWN
	while  !MOUSE.button eq 1  do begin
		x_click = round( x_click * s[0] )  &  y_click = round( y_click * s[1] )
		m = get_max( extract( image, boxsize, X = x_click, Y = y_click, $
							  LO_X = lx, LO_Y = ly ) )
		x_click = x_click + m[0] - ( x_click - lx )
		y_click = y_click + m[1] - ( y_click - ly )
		if  keyword_set( mark )  then $
		   crosses, tvrd(), x_click / s[0] * ws[0], y_click / s[1] * ws[1], $
		   			_EXTRA = extra
		x_saved = add_elements( x_saved, x_click )
		y_saved = add_elements( y_saved, y_click )
		cursor, x_click, y_click, /NORMAL, /DOWN
	endwhile
	if  n_elements( x_saved ) ne 0  then begin
		x = x_saved  &  y = y_saved
	endif
	remove_coincident, x, y, x, y
	return
   end
