   ; CLICK_ON_MAX: interactive selection of local maxima of a displayed
   ;	image. The window containing the image must be currently active.
   ;	Click on the desired local maxima with the left button of the mouse;
   ;	click on the right button to exit. The positional accuracy of the
   ;	click is defined by the input keyword boxsize (see below).

   ; INPUT
   ;	image: displayed image
   ;	[BOXSIZE = ]: size of box to search for a local maximum in the
   ;		neighborhood of a mouse click (default = 11)
   ;	[/MARK]: put a cross on each selected peak
   ; OUTPUT
   ;	x, y: positions of local maxima in image coordinates

   PRO click_on_max, image, BOXSIZE = boxsize, MARK = mark, x, y

	s = mysize( image, /DIM )  &  sx = s[0]  &  sy = s[1]
	if  n_elements( boxsize ) eq 0  then  boxsize = 11
	print, 'Select peak(s) by mouse left button click'
	print, 'Push right button to exit'
	!MOUSE.button = 1
	repeat begin
		cursor, x_click, y_click, /NORMAL, /DOWN
		x_click = round( x_click * sx )  &  y_click = round( y_click * sy )
		m = get_max( extract( image, boxsize, boxsize,  $
							  X = x_click, Y = y_click, $
							  LO_X = lx, LO_Y = ly ) )
		x_click = x_click + m[0] - ( x_click - lx )
		y_click = y_click + m[1] - ( y_click - ly )
		x_saved = add_elements( x_saved, x_click )
		y_saved = add_elements( y_saved, y_click )
	endrep until  !MOUSE.button ne 1
	npoints = n_elements( x_saved )
	if  npoints gt 1  then begin	; the last click was to stop the selection
		x = x_saved[0:npoints-2]  &  y = y_saved[0:npoints-2]
	endif
	remove_coincident, x, y, x, y
	return
   end