   PRO eq_points, x0, y0, v0, x1, y1, v1, MIN_DIST = min_dist, $
		  x0out, y0out, v0out, x1out, y1out, v1out, $
		  XFALSE = xf, YFALSE = yf, VFALSE = vf, $
		  XLOST = xl, YLOST = yl, VLOST = vl

	if  n_elements( min_dist ) eq 0  then  min_dist = 0.5
	s = size(x0)   &  s = s[1]
	x0out = x0-x0  & y0out = x0out  &  v0out = x0out
	x1out = x0out  & y1out = x0out  &  v1out = x0out
	k = 0  &  marked0 = byte( v0 - v0 )  &  marked1 = byte( v1 - v1 )
	for  i = 0, s - 1  do begin
	   d = distance( x1, y1, x0[i], y0[i] )
	   mindist = min( d, w )
	   if  mindist lt min_dist and not marked1[w]  then begin
	      x0out[k] = x0[i] & y0out[k] = y0[i] & v0out[k] = v0[i]
	      x1out[k] = x1[w] & y1out[k] = y1[w] & v1out[k] = v1[w]
	      k = k + 1  &  marked0[i] = 1B  &  marked1[w] = 1B
	   endif
	endfor
	if k gt 0 then begin
	   x0out = x0out[0:k-1]
	   y0out = y0out[0:k-1]
	   v0out = v0out[0:k-1]
	   x1out = x1out[0:k-1]
	   y1out = y1out[0:k-1]
	   v1out = v1out[0:k-1]
	endif
	w = where( marked1 eq 0, n )
	if  n ne 0  then begin
	   xf = x1[w]  &  yf = y1[w]  &  vf = v1[w]
	endif
	w = where( marked0 eq 0, n )
	if  n ne 0  then begin
	   xl = x0[w]  &  yl = y0[w]  &  vl = v0[w]
	endif
	return
   end





   ; INPUT:
   ;	x0, y0, m0: original set
   ;	x, y: subset of (x0,y0)
   ;	dx, dy, dm: errors associated to each element of the set (x,y)
   ; OUPUT:
   ;	For each element in (x,y), determine:
   ;	ae_sep, ae_dm, ae_m: astrometric and photometric separation from
   ;		the nearest element among the brighter ones in the original set,
   ;		considering the astrometric errors (dx,dy) as figure of merit
   ;	pe_sep, pe_dm, pe_m: same as above, but considering the photometric
   ;		errors dm as figure of merit

   PRO large_errors, x0, y0, m0, x, y, dx, dy, dm, $
		     ae_sep, ae_dm, ae_m, pe_sep, pe_dm, pe_m

	astro_error = 0.5  &  phot_error = 0.5
	wae = where( sqrt( dx^2 + dy^2 ) gt astro_error, nae )
	wpe = where( abs( dm ) gt phot_error, npe )
	if  nae ne 0  then $
	   find_closest_brighter, x0, y0, m0, x, y, wae, ae_sep, ae_dm, ae_m
	if  npe ne 0  then $
	   find_closest_brighter, x0, y0, m0, x, y, wpe, pe_sep, pe_dm, pe_m
	return
   end



   PRO find_closest_brighter, x0, y0, m0, x, y, w, sep, dm, mag

	n = n_elements( w )
	sep = fltarr( n )  &  dm = fltarr( n )  &  mag = fltarr( n )
	for  i = 0, n - 1  do begin
	   w0 = where( x[w[i]] eq x0 and y[w[i]] eq y0 )  &  w0 = w0[0]
	   sep[i] = min( distance( x0[0:w0-1], y0[0:w0-1], x0[w0], y0[w0] ), k )
	   dm[i]  = m0[w0] - m0[k]  &  mag[i] = m0[w0]
	endfor
	return
   end
