PRO compare_xy ,arr1,arr2,rmax,xoffset,yoffset,com,PRINT=print,GRAPHTITLE=graphtitle

if n_params() LT 2 then begin
        print,'SYNTAX:'
        print,'compare,arr1(x1,y1,mag1),arr2(x2,y2,mag2),[rmax,[xoffset,yoffset,com]],[PRINT=''filename'']'
        print,''
        print,'xoffset is between the two coordinates systems offset=x1-x2, default is 0'
        print,''
        print,'from 2 list of x,y,mag find which positions coincide in a radius (rmax) and print an array to compare xy positions and magnitude'
        print,'rmax default is 4'
        print,''
        print,'print also the mean and standart deviation of x1-x2,y1-y2,mag1-mag2'
        print,''
        print,'plot a graph which is mag1-mag2 versus mag1'
	print,'plot a graph which is x1-x2 versus mag1'
	print,'plot a graph which is y1-y2 versus mag1'
        print,'set PRINT= ''name_of_psfile_to_print'' to save this plot into a postscript file'  
        print,''
        print,'add argument "com" if you want to output an array which contains the array printed on your screen '
        print,''
        return
 endif

if n_params() LT 3 then begin
 rmax=4
 xoffset=0. 
 yoffset=0.
endif

if n_params() LT 4 then begin
         xoffset=0. 
         yoffset=0.
endif

srcor,arr1(0,*),arr1(1,*),arr2(0,*)+xoffset,arr2(1,*)+yoffset,rmax,id1,id2,option=1
print,''

if n_elements(id1) EQ 0 then begin
        print,'no match found'
        return
endif

com=fltarr(8,n_elements(id1))
com=[arr1(0,[id1]),arr1(1,[id1]),arr1(2,[id1]),arr2(2,[id2]),arr1(2,[id1])-arr2(2,[id2]),arr1(0,[id1])-arr2(0,[id2]),arr1(1,[id1])-arr2(1,[id2]),sqrt((arr1(0,[id1])-arr2(0,[id2]))^2+(arr1(1,[id1])-arr2(1,[id2]))^2)]

;com=[arr1(0,[id1]),arr1(1,[id1]),arr1(2,[id1])-min(arr1(2,[id1])),arr2(2,[id2])-min(arr2(2,[id2])),arr1(2,[id1])-arr2(2,[id2])-min(arr1(2,[id1]))+min(arr2(2,[id2]))]


ordre=sort(com(2,*))

com=[com(0,[ordre]),com(1,[ordre]),com(2,[ordre]),com(3,[ordre]),com(4,[ordre]),com(5,[ordre]),com(6,[ordre]),com(7,[ordre])]


print,'         x1          y1          mag1         mag2      mag1-mag2       x1-x2       y1-y2        distance'
print,com
print,n_elements(id1),' commons stars found'
print,''
resx=moment(arr1(0,[id1])-arr2(0,[id2]))
print,'mean(x1-x2)= ',resx(0)
print,'standart deviation = ',sqrt(resx(1))
print,''

resy=moment(arr1(1,[id1])-arr2(1,[id2]))
print,'mean(y1-y2)= ',resy(0)
print,'standart deviation = ',sqrt(resy(1))
print,''

resdist=moment(com(7,*))
print,'mean distance=',resdist(0)
print,'standart deviation = ',sqrt(resdist(1))
print,''

resmag=moment(com(4,*))
print,'mean(mag1-mag2)= ',resmag(0)
print,'standart deviation = ',sqrt(resmag(1))
print,''

if not keyword_set(GRAPHTITLE) then graphtitle= 'comparison between two arrays'

window,9,title='compare_xy.pro',xsize=512,ysize=900
!P.multi=[0,1,4]
plot,com(2,*),(com(4,0:*)),xtitle='magnitudes of first array',ytitle='difference between magnitudes',psym=4,title=graphtitle,charsize=1.7

plot,com(2,*),(com(5,0:*)),xtitle='magnitudes of first array',ytitle='difference between x positions',psym=4,yrange=[min(com(5,*)),max(com(5,*))],charsize=1.7

plot,com(2,*),(com(6,0:*)),xtitle='magnitudes of first array',ytitle='difference between y positions',psym=4,yrange=[min(com(6,*)),max(com(6,*))],charsize=1.7


plot,com(2,*),(com(7,0:*)),xtitle='magnitudes of first array',ytitle='error in distance between stars ',psym=4,yrange=[min(com(7,*)),max(com(7,*))],charsize=1.7

!P.MULTI=0

if keyword_set(PRINT) then begin
        set_plot,'ps'
        device,filename=print,ysize=22,yoffset=5
!P.multi=[0,1,4]

plot,com(2,*),(com(4,0:*)),xtitle='magnitudes of first array',ytitle='difference between magnitudes',psym=4,title=graphtitle,charsize=1.7

plot,com(2,*),(com(5,0:*)),xtitle='magnitudes of first array',ytitle='difference between x positions',psym=4,yrange=[min(com(5,*)),max(com(5,*))],charsize=1.7

plot,com(2,*),(com(6,0:*)),xtitle='magnitudes of first array',ytitle='difference between y positions',psym=4,yrange=[min(com(6,*)),max(com(6,*))],charsize=1.7


plot,com(2,*),(com(7,0:*)),xtitle='magnitudes of first array',ytitle='error in distance between stars ',psym=4,yrange=[min(com(7,*)),max(com(7,*))],charsize=1.7

!P.MULTI=0



        device,/close
        set_plot,'x'
        endif
return

end
