PRO comparelist0 ,l1,l2,xoffset,yoffset,com,NCOL=ncol,PTOL=rmax,MTOL=mtol,$
			MRANGE=mrange,NB=nb,ID=ID,PRINTFILE=printfile,$
			SCOL1=scol1,SCOL2=scol2,OUTCOL=outcol,NOGRAPH=nograph, $
			PSGRAPH=psgraph,ROT=rot,PSCALE=pscale
			
;NAME:
;	COMPARELIST

;PURPOSE:
;	Match positions in two lists and give a comparison of commons
;	stars in term of magnitude and position. Output ascii file and Graph (ps).

;CALLING SEQUENCE
;	comparelist ,l1,l2,xoffset,yoffset,com,NCOL=ncol,PTOL=rmax,MTOL=mtol,$
;			MRANGE=mrange,NB=nb,ID=ID,PRINTFILE=printfile,$
;			SCOL1=scol1,SCOL2=scol2,OUTCOL=outcol,/NOGRAPH, $
;			PSGRAPH=psgraph,ROT=rot,PSCALE=pscale

;INPUT:
;	L1,L2 - lists of positions and magnitudes. It can be both the name of an
;	    ascii file (scalar string) or an array of values (x,y,magnitude).
;	    In case of an ascii file NCOL keyword must be specified.
;	    First, second and third columns are supposed to be X,Y and MAG.
;	    (If not, SCOL1 and SCOL2 Keywords must be used).
	 
;OPTIONAL INPUT:   
;	XOFFSET,YOFFSET - X and Y offsets between frames (scalar) defined as
;				follow: XOFFSET=X2-X1 and YOFFSET=Y2-Y1

;OPTIONAL OUTPUT:
;	COM - name of an output variable which will contain the following results
;		X1,Y1,MAG1,X2,Y2,MAG2,MAGERR,XERR,YERR where:
;		 	MAGERR= MAG2-MAG1, XERR=X2-X1, YERR=Y2-Y1 	

;OPTIONAL KEYWORD:

;	ROTATION AND SCALING PARAMETERS:

;	ROT - A 3 elements vectors specifying [angle(deg),xoffset,yoffset] 
;		Stars in list 1 are rotated and then translated to match with
;		list 2. X and Y Error correspond then to the residual offset
;		after rotation only.
;	PSCALE - Scalar elements of (IM1 Pixel scale)/(IM2 Pixel scale) if
;			im1 and im2 have differents pixel scale. In that 
;			case the printed or writed x2 and y2 coordinates are
;			in im1 scale.

;	SELECTION CRITERIONS KEYWORDS:
;
;	PTOL - Radius of the maximal area in which two stars match. In case of 
;		several matches inside PTOL, the closest star is taken. Default
;		is 3 pixels.
;	MTOL - Maximal error in magnitude accepted. If the magnitude difference 
;		between two stars is greater than MTOL, they are rejected.
;		Default is infinite.
;	MRANGE - two elements vector giving the range of magnitude considered
;		If magnitudes (MAG1,MAG2) are not inside MRANGE, stars are 
;		rejected. Default is infinite.
;	NB - Select only the NB brightest stars, the others are rejected.
;	ID - vector of subscript of the common list of stars to be manually
;		 rejected. 	

;    	INPUT/OUTPUT FORMAT KEYWORDS:
;
;	NCOL - Number of Columns of the input ascii files. Default is [3,3]
;	PRINTFILE - Name of an output ascii file (scalar string) which will
;		contain the results specified by OUTCOL and the optional
;		additional parameters given by SCOL1 and SCOL2.
;	SCOL1,SCOL2 - The numero of the column of L1 and L2 containing X,Y,MAG
;		 and the additional parameters to be added in the output
;		 ascii file. Be Carreful the first,second and third value of SCOL
;		are only used to locate x,y,mag in the input ascii file. The others
;		are "additional parameters" which will be writen in the output 
;		file if PRINTFILE keyword is specified.
;		So SCOL1 and SCOL2 can be used to specify the columns 
;		numeros of X,Y,MAG (default is SCOL1=[1,2,3] SCOL2=[1,2,3]).
;	      EXAMPLE: SCOL1=[2,3,4,5,6] will consider in L1: 
;		the 2nd column as X, the third as Y, column 4 as MAG, and 
;		column 5 and 6 as additional parameters which will be writen in
;		the output ascii file. 
;	OUTCOL - Vector of wanted output parameters:
;		0,1,2 correspond to X1,Y1,MAG1.
;		3,4,5 correspond to X2,Y2,MAG2.
;		6,7,8 correspond to MAGERR, XERR, YERR
;		EXAMPLE: OUTCOL=[0,1,2,6] will write X1,Y1,MAG1,MAGERR + the 
;			additional parameters in the output ascii file. 	 				  
;		Default is OUTCOL=[0,1,2,3,4,5,6,7,8]
;	NOGRAPH - No graph printed on screen.
;	PSGRAPH - Name of the postscript file which contain the graph $
;			(scalar string). 

;EXAMPLE:
;	comparelist,'tuc47_0.xym.dat','tuc47_3.xym.dat',21,30,ncol=[6,6],$
;		ptol=1.,SCOL1=[2,3,4,6],SCOL2=[2,4,3,5],OUTCOL=[0,1,2,6],$
;		PRINTFILE='test.txt',NB=40
;	Will read 'tuc47_0.xym.dat' and 'tuc47_3.xym.dat' which contain 6 
;	columns each. It will considered that X,Y,MAG are column 2,3,4 in 
;	'tuc47_0.xym.dat' and column 2,4,3 in 'tuc47_3.xym.dat'. It's assumed
;	that the approximate offset between frame is (21,30). It will consider
;	also only the 40 brightest stars. An ascii file called test.txt will be
;	output and contain the following column: X1,Y1,MAG1,MAGERR,column 6 of
;	'tuc47_0.xym.dat', and column 5 of 'tuc47_3.xym.dat'


;RESTRICTIONS
;	If too many columns are writen is the output file then it involves
;	problems with alignement. One should not output more than 9 or 10 
;	columns.

;PROCEDURES CALLED:
;	SRCOR, REMOVE


if n_params() LT 2 then begin
print,'SYNTAX'
print,'comparelist ,l1,l2,xoffset,yoffset,com,NCOL=ncol,PTOL=rmax,MTOL=mtol,$'
print,'			MRANGE=mrange,NB=nb,ID=ID,PRINTFILE=printfile,$'
print,'			SCOL1=scol1,SCOL2=scol2,OUTCOL=outcol,/NOGRAPH, $'
print,'			PSGRAPH=psgraph,ROT=rot,PSCALE=pscale'
        return
 endif

if NOT keyword_set(SCOL1) then scol1=[1,2,3]
if NOT keyword_set(SCOL2) then scol2=[1,2,3]
if NOT keyword_set(PTOL) then rmax=3
if NOT keyword_set(NCOL) then ncol=[3,3]
if n_params() LT 4 then begin xoffset=0. & yoffset=0.
endif

;READ ASCII FILE WITH NCOL COLUMNS
diml1=size(l1) & diml2=size(l2)
if diml1(1) EQ 7 then begin
	openr,lun,l1,/get_lun
	file1=fltarr(ncol(0),numlines(l1))
	readf,lun,file1
	close,lun
	l1=file1
endif
if diml2(1) EQ 7 then begin
	openr,lun,l2,/get_lun
	file2=fltarr(ncol(1),numlines(l2))
	readf,lun,file2
	l2=file2
	close,lun
endif

l11=l1(scol1(0)-1,*) & l12=l1(scol1(1)-1,*)
l13=l1(scol1(2)-1,*)
l21=l2(scol2(0)-1,*) & l22=l2(scol2(1)-1,*)
l23=l2(scol2(2)-1,*)

if keyword_set(PSCALE) then begin
	l21=l21/float(pscale)
	l22=l22/float(pscale)
endif

;ROTATION ANGLE AND TRANSLATION COMPUTATION
if keyword_set(ROT) then begin
	l11rot=fltarr(n_elements(l11)) & l12rot=fltarr(n_elements(l11))
	ang=(rot(0)/180.)*3.14159
	for i=0,n_elements(l11)-1 do begin 
		l11rot(i)=l11(i)*cos(ang)-l12(i)*sin(ang)
		l12rot(i)=l11(i)*sin(ang)+l12(i)*cos(ang)
	endfor
	srcor,l11rot,l12rot,l21-rot(1),l22-rot(2),rmax,id1,id2,option=1
endif else begin

;POSITIONS MATCHES
	srcor,l11,l12,l21-xoffset,l22-yoffset,rmax,id1,id2,option=1
endelse
print,''
initmatches=n_elements(id1)
matches=initmatches
if id1(0) EQ -1 then begin
       	print,'NO MATCH FOUND'
        return
endif

;SELECT STARS WITH SATISFIED MTOL CRITERION
if keyword_set(mtol) then begin
	delmtol=where(Abs(l13(id1)-l23(id2)) GT mtol,magrej)
	if delmtol(0) NE -1 then remove,delmtol,id1,id2
	matches=matches-magrej
endif else magrej=0

;SELECT STARS INSIDE MRANGE CRITERION 
if keyword_set(MRANGE) then begin
	delmr=where((l13(id1) LT mrange(0)) OR (l13(id1) GT mrange(1)),mrrej)
	if delmr(0) NE -1 then remove,delmr,id1,id2
	matches=matches-mrrej
endif else mrrej=0

;ORDER RESULTS (increasing magnitude) AND (OPTIONAL) SELECT NB BRIGHTEST STARS
mo=sort(l13(id1))
id1=id1[mo] & id2=id2[mo]
if keyword_set(NB) then begin
	id1=id1(0:nb-1) & id2=id2(0:nb-1)
	matches=nb
endif else nb=0

;ID CRITERION REJECTION
if keyword_set(ID) then begin
	idrej=n_elements(id)
	remove,id,id1,id2
	matches=matches-idrej
endif else idrej=0

if keyword_set(ROT) then begin
	errmag=-l13(id1)+l23(id2) 
	errx=-l11rot(id1)+l21(id2) & erry=-l12rot(id1)+l22(id2)
endif else begin
	errmag=-l13(id1)+l23(id2) 
	errx=-l11(id1)+l21(id2) & erry=-l12(id1)+l22(id2)
endelse

com=fltarr(9,matches)
com(0,*)=l11(id1) & com(1,*)=l12(id1) & com(2,*)=l13(id1)
com(3,*)=l21(id2) & com(4,*)=l22(id2) & com(5,*)=l23(id2)
com(6,*)=errmag & com(7,*)=errx & com(8,*)=erry 

print,'ID   X1      Y1     MAG1     X2      Y2     MAG2    MAGErr   XErr   YErr'
for i=0,matches-1 do print,strtrim(string(i),1),$
			string(com(*,i),format='(F7.2)') & print,''

;PERFORM AND PRINT ON SCREEN STATISTIC RESULTS 
if matches GT 1 then begin 
	resx=moment(errx) & resy=moment(erry) & resmag=moment(errmag)
endif else begin
 	resx=[errx,0] & resy=[erry,0] & resmag=[errmag,0]
endelse
print,'Initial matches found in list 1 and list2  = ',strtrim(initmatches,1) 
print,'# of stars rejected by Error Mag Criterion = ',strtrim(magrej,1)
print,'# of stars rejected by Range Mag Criterion = ',strtrim(mrrej,1)
print,'# of stars rejected by ID Criterion        = ',strtrim(idrej,1)
print,''
print,'                    STATISTIC PARAMETERS OF LISTS'
print,' ----------------------------------------------------------------'
print,'|        List         |    List 1    |   List 2   |  Common list | '
print,' ----------------------------------------------------------------'
print,'| Number of Stars     |',n_elements(l11),n_elements(l21),matches,'          |'
print,'| Brightest Magnitude |',min(l13),min(l23),min([min(l13[id1]),$
							min(l23[id2])]),'   |'
print,'| Faintest Magnitude  |',max(l13),max(l23),max([max(l13[id1]),$
							max(l23[id2])]),'   |'
print,' ----------------------------------------------------------------'
print,''
print,' 	                       PERFORMANCE TABLE'
print,' ----------------------------------------------------------------'
print,'|      Parameters    |    Magnitude  | X position  | Y position  |'
print,' ----------------------------------------------------------------' 
print,'| Mean Error         |',resmag(0),resx(0),resy(0),'    |'
print,'| Minimum Error      |',min(errmag),min(errx),min(erry),'    |'
print,'| Maximum Error      |',max(errmag),max(errx),max(erry),'    |'
print,'| Standart Deviation |',sqrt(resmag(1)), sqrt(resx(1)),sqrt(resy(1)),'    |'
print,' ----------------------------------------------------------------' 
print,''

;PRINT TABLE in an ASCII FILE
if keyword_set(printfile) then begin
	openw,lun,printfile,/get_lun
	l1=l1(*,id1) & l2=l2(*,id2)
if ((n_elements(scol1) NE 3) OR (n_elements(scol2) NE 3)) then begin
	if ((n_elements(scol1) GT 3) AND (n_elements(scol2) GT 3)) then $
		 addp=[l1(scol1(3:*)-1,*),l2(scol2(3:*)-1,*)]
	if ((n_elements(scol2) GT 3) AND (n_elements(scol1) LT 4)) then $
		 addp=l2(scol2(3:*)-1,*)	
	if ((n_elements(scol1) GT 3) AND (n_elements(scol2) LT 4)) then $
		addp=l1(scol1(3:*)-1,*)
	for i=0,matches-1 do printf,lun,[strtrim(string(com(outcol,i), $ 
		format='(F7.2)'),1),strtrim(addp(*,i),1)]
	endif else for i=0,matches-1 do printf,lun,string(com(outcol,i),$
		format='(F7.2)')
	close,lun
endif

;PRINT GRAPH ON SCREEN
if not keyword_set(NOGRAPH) then begin
	window,9,title='Comparelist.pro',xsize=512,ysize=900
	!P.multi=[0,1,3]
	graphtitle='Comparison of two lists of stars'
	plot,com(2,*),(com(6,0:*)),xtitle='List1 magnitudes',$
		ytitle='Error in magnitudes',psym=4,title=graphtitle,$
		charsize=1.7
	oplot,[min(com(2,*))-2,max(com(2,*))+2],[resmag(0),resmag(0)],linestyle=1
	plot,com(2,*),com(7,0:*),xtitle='List1 magnitudes',$
		ytitle='Error in X positions (pix)',psym=4,$
		yrange=[min(com(7,*)),max(com(7,*))],charsize=1.7
	oplot,[min(com(2,*))-2,max(com(2,*))+2],[resx(0),resx(0)],linestyle=1
	plot,com(2,*),(com(8,0:*)),xtitle='List1 magnitudes',$
		ytitle='Error in Y positions',psym=4,$
		yrange=[min(com(8,*)),max(com(8,*))],charsize=1.7
	oplot,[min(com(2,*))-2,max(com(2,*))+2],[resy(0),resy(0)],linestyle=1
	!P.MULTI=0
endif

;PRINT GRAPH IN PS FILE
if keyword_set(PSGRAPH) then begin
 	set_plot,'ps'
        device,filename=psgraph,ysize=22,yoffset=5
	!P.multi=[0,1,3]
	graphtitle=psgraph+' Comparison of two lists of stars'
	plot,com(2,*),(com(6,0:*)),xtitle='List1 magnitudes',$
		ytitle='Error in magnitudes',psym=4,title=graphtitle,$
		charsize=1.7
	oplot,[min(com(2,*))-2,max(com(2,*))+2],[resmag(0),resmag(0)],linestyle=1
	plot,com(2,*),(com(7,0:*)),xtitle='List1 magnitudes',$
		ytitle='Error in X positions (pix)',psym=4,$
		yrange=[min(com(7,*)),max(com(7,*))],charsize=1.7
	oplot,[min(com(2,*))-2,max(com(2,*))+2],[resx(0),resx(0)],linestyle=1
	plot,com(2,*),(com(8,0:*)),xtitle='List1 magnitudes',$
		ytitle='Error in Y positions',psym=4,$
		yrange=[min(com(8,*)),max(com(8,*))],charsize=1.7
	oplot,[min(com(2,*))-2,max(com(2,*))+2],[resy(0),resy(0)],linestyle=1
	!P.MULTI=0
	device,/close
	set_plot,'x'
endif
close,/all
return
end
