   ; CONVERGENCE: return 'true' if the modulus of the error between
   ;	x0 and x1 is < tol. The error is absolute if /ABSOLUTE is set,
   ;	otherwise it is relative.

   FUNCTION convergence, x0, x1, tol, ABSOLUTE = absolute

	if  keyword_set( absolute )  then  error = abs_error( x0, x1 ) $
	else  error = abs( rel_error( x0, x1 ) )
	return, max( error ) lt tol
   end
