   ; CONVOLUTION: convolve a 2-D image with a 2-D Point Spread Function,
   ;	using the Fourier Transform convolution theorem.

   ; INPUT
   ;	image, psf: image and PSF to be convolved
   ;	[FT_IMAGE = ]: Fourier Transform of image
   ;	[FT_PSF = ]: Fourier Transform of psf
   ;	[/NO_EXTEND]: image and psf are extended before convolution.
   ;		The extended size is the sum of image size and psf size.
   ;		If /NO_EXTEND is set, psf is simply extended to image size
   ;	[/NO_NORM]: psf is not normalized to total volume = 1
   ;	[/CORRELATE]: compute correlation instead of convolution
   ;	[/RETURN_FT]: the returned array is the Fourier Transform of the
   ;		convolution (or correlation)
   ; OUTPUT
   ;	Return the convolved image or its FT if /RETURN_FT is set. If image
   ;	or psf are not 2-D, return image as convolved array. The convolved
   ;	array has the same size as the input image.
   ;	[FT_IMAGE = , FT_PSF = ]: Fourier Transforms of image and psf to be
   ;		used in a subsequent convolution

   FUNCTION convolution, image, psf, FT_IMAGE = image_ft, FT_PSF = psf_ft, $
						 NO_EXTEND = no_extend, NO_NORM = no_norm, $
						 CORRELATE = correlate, RETURN_FT = return_ft

	if  mysize( image, /N_DIM ) ne 2 or mysize( psf, /N_DIM ) ne 2  then $
	   return, image
	; Determine size of arrays
	s = mysize( image, /DIM )  &  sx_image = s[0]  &  sy_image = s[1]
	s = mysize( psf, /DIM )    &  sx_psf   = s[0]  &  sy_psf   = s[1]
	sx = sx_image  &  sy = sy_image
	if  not keyword_set( no_extend )  then begin
	   sx = sx + sx_psf  &  sy = sy + sy_psf
	endif
	; Pre-processing of image
	if  n_elements( image_ft ) eq 0  then $
	   image_ft = fft( extend_array( image, sx, sy ) )
	; Pre-processing of psf
	if  n_elements( psf_ft )   eq 0  then begin
	   p = psf  &  if  not keyword_set( no_norm )  then  p = normalize( p )
	   psf_ft = fft( center_image( extend_array( p, sx, sy ), 0, 0, /NO_EXT ) )
	endif
	; Compute convolution or correlation
	if  not keyword_set( correlate )		then $
	   conv = image_ft * psf_ft * sx * sy	else $
	   conv = image_ft * conj( psf_ft ) * sx * sy
	if  not keyword_set( return_ft )  then begin
	   conv = float( fft( conv, /INVERSE ) )
	   conv = conv[0:sx_image-1,0:sy_image-1]
	endif
	return, conv
   end