   ; COORD_TO_SUBS: given a set of coordinates (x,y), identifying a set of
   ;	pixels in a 2-D array, transform (x,y) to a 1-D vector of subscripts
   ;	to access the array in memory address order.

   ; INPUT
   ;	x, y: x- (column) and y- (row) coordinates of pixels
   ;	n_columns: number of columns in the array

   ; OUTPUT
   ;	Return 1-D vector of subscripts, such that
   ;		array[coord_to_subs( x, y, n_columns )]
   ;	is equivalent to array[x,y]

   FUNCTION coord_to_subs, x, y, n_columns

	return, round( y ) * n_columns + round( x )
   end