   ; CORRELATION_COEFF: compute the correlation coefficient of a pattern
   ;	with a reference template.

   ; INPUT
   ;	pattern, template (same size)
   ;	[EXCLUDE = ]: array of subscripts for pixels to be excluded
   ; OUTPUT
   ;	Return the correlation coefficient.

   FUNCTION correlation_coeff, pattern, template, EXCLUDE = e

	s = lindgen( n_elements( pattern ) )
	if  n_elements( e ) ne 0  then  if  e[0] ge 0  then $
	   if  n_elements( e ) ge n_elements( pattern )  then  return, 0 $
	   else begin
	      s[e] = -1  &  s = s[ where( s ge 0 ) ]
	   endelse
	p = pattern[s]   &  p = p - mean( p )
	t = template[s]  &  t = t - mean( t )
	return, total( p*t ) / sqrt( total( p*p ) * total( t*t ) )
   end



