FUNCTION cova_zern,jmax

; Calcule la matrice de covariance de Zernike
; La procedure zern_num.pro permet de determiner le degre radial et 
; azimuthal pour un numero de Zernike donne
; il suffit d'entrer le numero de zernike maximum
; Atmospheric wavefront simulation using Zernike Polynomials,N. Roddier, 
; Optical Engineering, Oct 90, vol 29 no 10


IF n_elements(jmax) NE 1L THEN message, "SYNTAX: result=cova_zern(jmax)"


c = fltarr(jmax-1,jmax-1)
FOR j=2,jmax DO BEGIN
FOR jp=2,jmax DO BEGIN 

zern_num,j,n=n,m=m
zern_num,jp,n=np,m=mp


k_zz = gamma(14D0/3D0)*(24D0/5D0*gamma(6D0/5D0))^(5D0/6D0)*(gamma(11D0/6D0))^2D0$
       /(2D0*(!Dpi)^2D0)

K = k_zz * (-1)^((n+np-2D0*m)/2D0) *sqrt((n+1)*(np+1))
IF (m EQ mp) AND ((j*jp/2D0 NE long(j*jp/2D0)) OR ((j/2D0 EQ long(j/2D0)) AND $
                                                   (jp/2D0 EQ long(jp/2D0))) $
                  OR (m EQ 0)) THEN C[j-2,jp-2] = K * gamma((n+np-5D0/3D0)/2D0) / $
          (gamma((n-np+17D0/3D0)/2D0) * gamma((np-n+17D0/3D0)/2D0) * $
           gamma((n+np+23D0/3D0)/2D0)) ELSE C[j-2,jp-2] = 0D0
ENDFOR
ENDFOR
return,c

END
