   ; CROSSES: display a set of points on a 2-D image.
   ; There are two display modes:
   ; 1) Only image and coordinates are supplied
   ; 2) Image, coordinates, window number and size are supplied
   ; In case 1), the input coordinates are assumed to be in window pixels
   ; coordinates and the window is the currently active one. In case 2),
   ; the input coordinates are assumed to be in image pixels coordinates,
   ; thus both image and coordinates are scaled to fit the window size.
   ; The possible calling sequences are
   ; 1) CROSSES, image, x1, y1, X2 = x2, Y2 = y2
   ; 2) CROSSES, image, x1, y1, X2 = x2, Y2 = y2, wnum, wsize

   ; INPUT
   ;	image: image to be displayed
   ;	x1, y1: points to be marked on the image display
   ;	[X2 = , Y2 = ]: second set of points to be marked
   ;		with a different symbol
   ;	[wnum]: window number for display (default: current window)
   ;	[wsize]: window size (scalar or 2-element array,
   ;		if the window is not square)
   ;	[_EXTRA = ]: optional input keywords for IDL PLOTS
   ; NOTE: points (x1,y1) are marked by a '+' sign; (x2,y2) by a 'x' sign.

   PRO crosses, image, x1, y1, X2 = x2, Y2 = y2, wnum, wsize, _EXTRA = extra

	if  n_params() eq 4  then  return
	if  mysize( image, /N_DIM ) ne 2  then  return
	s = float( mysize( image, /DIM ) )
	if  n_elements( wsize ) eq 0  then  ws = [!D.x_size, !D.y_size]  else $
	if  n_elements( wsize ) eq 1  then  ws = [wsize, wsize]  else  ws = wsize
	ws = ws[0:1]
	if  n_elements( wnum ) ne 0  then $
	   window, wnum, XSIZE = ws[0], YSIZE = ws[1]
	tvscl, congrid( image, ws[0], ws[1] )
	xscale = ( ws[0] - 1 ) / ( s[0] - 1 )
	yscale = ( ws[1] - 1 ) / ( s[1] - 1 )
	plots, x1 * xscale, y1 * yscale, PSYM = 1, /DEVICE, _EXTRA = extra
	if  n_elements( x2 ) * n_elements( y2 ) ne 0  then $
	   plots, x2 * xscale, y2 * yscale, PSYM = 7, /DEVICE, _EXTRA = extra
	return
   end