   ; CROSSES: display a set of points on a 2-D image.

   ; INPUT
   ;	image: image to be displayed
   ;	x1, y1: points to be marked on the image display
   ;	[X2 = , Y2 = ]: second set of points to be marked
   ;		with a different symbol
   ;	[wnum]: window number for display (default: current window)
   ;	[ws]: window size (scalar or 2-element array,
   ;		if the window is not square)
   ;	[_EXTRA = ]: optional input keywords for IDL PLOTS
   ; NOTE: points (x1,y1) are marked by a '+' sign; (x2,y2) by a 'x' sign.

   PRO crosses, image, x1, y1, X2 = x2, Y2 = y2, wnum, ws, _EXTRA = extra

	if  mysize( image, /N_DIM ) ne 2  then  return
	s = mysize( image, /DIM )  &  sx = float( s[0] )  &  sy = float( s[1] )
	if  n_elements( ws ) eq 0  then  wsize = [!D.x_size, !D.y_size]  else $
	if  n_elements( ws ) eq 1  then  wsize = [ws, ws]  else  wsize = ws
	wx = wsize[0]  &  wy = wsize[1]
	if  n_elements( wnum ) ne 0  then  window, wnum, XSIZE = wx, YSIZE = wy
	tvscl, congrid( image, wx, wy )
	xscale = ( wx - 1 ) / ( sx - 1 )  &  yscale = ( wy - 1 ) / ( sy - 1 )
	plots, x1 * xscale, y1 * yscale, PSYM = 1, /DEVICE, _EXTRA = extra
	if  n_elements( x2 ) * n_elements( y2 ) ne 0  then $
	   plots, x2 * xscale, y2 * yscale, PSYM = 7, /DEVICE, _EXTRA = extra
	return
   end