function dao,image,psfname,hmin,fwhm,aper,skymin,skymax,rgroup,phpadu,ron,SUBSTRACT=substract,LIST=list,PLOT=plot,IDLIST=idlist,DARKRING=darkring

if ((N_PARAMS() LT 4) OR (N_PARAMS() GT 10)) then begin
	print,'SYNTAX'
	print,'array=DA0(image,psfname,hmin,fwhm,[apr,[skymin,[skymax,[rgroup,[phpadu,[ron]]]]]]],SUBSTRACT=''substractedfile.fits'',LIST=list,IDLIST=idlist,PLOT=plot,DARKRING=darkring)'
	print,'array is [x,y,mags]'
	print,''
	print,'optional input are phpadu (default 9.36) and ron (default 38.)' 
	print,''
	print,'if keyword "SUBSTRACT" set then substract the psf for each star and write the resulting image in a fits file'
	print,''
	print,'if keyword LIST set then you supply a list of star ([x,y]) you want to do photometry on without running the find procedure'
	print,''
	print,'if keyword PLOT=nonzeroscalar set then display the image with the stars ids'
	print,''
	print,'if keyword idlist set (IDLIST=idvector), then substract only stars with the supllied ids'
	print,'if keyword DARKRING then you can choose as the aperture the first,second or third darkring. DARKRING must be a vector like [darkring number,wavelenght(micrometers),telescope diameter(meters),pixel size (arcsecond)]'
	return,0
endif 

arraysize=N_elements(image(0,*))
if N_PARAMS() LT 8 then rgroup=3*fwhm
if N_PARAMS() LT 9 then phpadu=9.36
if N_PARAMS() LT 10 then ron=38.

if NOT KEYWORD_SET(DARKRING) THEN BEGIN
	if N_PARAMS() LT 5 then aper=fix(2.5*fwhm)
	if N_PARAMS() LT 6 then skymin=fix(2.5*fwhm)
	if N_PARAMS() LT 7 then skymax=3*fwhm
ENDIF ELSE BEGIN
	darkring_number=darkring(0)
	lbd=darkring(1)*1e-6
	d=darkring(2)
	pixelsize=darkring(3)

	CASE darkring_number OF
		1:aper=1.22*lbd/d/pixelsize/4.85e-6
		2:aper=2.23*lbd/d/pixelsize/4.85e-6
		3:aper=3.2*lbd/d/pixelsize/4.85e-6
	ELSE: print,'choose the first(1),second(2),or third(3) dark ring.'
	ENDCASE
	skymin=aper+1.
	skymax=aper+4.
ENDELSE	

if NOT keyword_set(LIST) then find,image,x,y,flux,sharp,round,hmin,fwhm,[-1.,1.],[0.2,1.],/SILENT ELSE BEGIN
	print,'reads positions'
	x=list(0,*)
	y=list(1,*)
	ENDELSE

if N_elements(x) EQ 0 then return,[0,0,0]

aper,image,x,y,mags,errap,sky,skyerr,phpadu,aper,[skymin,skymax],[-32765,32767],/SILENT

if n_elements(x) GT 1 then group,x,y,rgroup,ng else ng=[0]
if total(x) EQ 0 AND total(y) EQ 0 then return,[0,0,0]

id=indgen(n_elements(x))

nstar,image,id,x,y,mags,sky,ng,phpadu,ron,psfname,magerr,iter,chisq
print,''
print,'aperture radius =',string(aper)
print,'annulus radius = [',string(skymin),',',string(skymax),']'
print,'group radius =',string(rgroup)
print,'phpadu =',string(phpadu)
print,'ron =',string(ron)
print,''

N=N_ELEMENTS(id)
if N EQ 1 AND mags(0) GT 99. then return,[0,0,0]

print,'number of stars returned is:',N
print,'mean(abs(1-chisq))=',mean(abs(1-chisq))
print,'chisq = chi square of the PSF fit for each output star'
print,''
res=fltarr(3,N)
res(0,*)=x
res(1,*)=y
res(2,*)=mags

id=indgen(n_elements(id))
if keyword_set(PLOT) then plotid,image,id,x,y,20,plot=plot
if NOT keyword_set(IDLIST) then idlist=-1

if keyword_set(SUBSTRACT) then begin
	image1=image
	substar,image1,x,y,mags,idlist,psfname
	writefits,substract,image1
	if keyword_set(PLOT) then begin
		plotid,image1,id,x,y,21
		window,22
		shade_surf,image1
	endif
endif
	
return,res

end
