   ; DISTANCE: compute the euclidean distance between a set of n points
   ;	(x,y) and a reference point (x0,y0). The computation is performed
   ;	in floating-point arithmetics.

   ; INPUT
   ;	x, y: coordinates of points
   ;	x0, y0: reference point
   ; OUTPUT
   ;	Return a n-components vector of distances. Return a negative
   ;	scalar if some anomaly is found on the points coordinates.

   FUNCTION distance, x, y, x0, y0

	if  n_elements( x )  ne n_elements( y ) or $
	    n_elements( x0 ) ne n_elements( y0 )	 then  return, -1
	if  n_elements( x0 ) ne 1  then  return, -1
	return, sqrt( (x - float(x0))^2 + (y - float(y0))^2 )
   end
