   ; ELLIPT_GAU_COEFF: Auxiliary function of GAUSSIAN_KERNEL.
   ;	Compute the semi-axes of an elliptical gaussian whose center
   ;	is located at a distance r from a reference position.

   ; INPUT
   ;	r: distance from the reference position (pixel units)
   ;	[L1 = , L2 = , ...]: linear and quadratic coefficients of
   ;		l(r) and w(r). For default values, see the code.
   ; OUTPUT
   ;	l, w: semi-axes of the elliptical gaussian (pixel units)
   ;	      (l: semi-major axis, w: semi-minor axis)

   PRO ellipt_gau_coeff, r, L1 = l1, L2 = l2, W1 = w1, W2 = w2, l, w

	if  n_elements( l1 ) eq 0  then  l1 = 0
	if  n_elements( l2 ) eq 0  then  l2 = 0
	if  n_elements( w1 ) eq 0  then  w1 = 0
	if  n_elements( w2 ) eq 0  then  w2 = 0
	l = ( l1 + l2 * r ) * r
	w = ( w1 + w2 * r ) * r
	return
   end
