   ; ELLIPT_GAU_LW: Auxiliary function of GAUSSIAN_KERNEL.
   ; Compute the semi-axes of an elliptical gaussian whose center
   ; is located at a distance r from a reference position.

   ; INPUT
   ;	r: distance from the reference position (pixel units)
   ;	l1, l2: linear and quadratic coefficients of best fit
   ;		polynomial to elongation data
   ;	w1, w2: linear and quadratic coefficients of best fit
   ;		polynomial to width data
   ; OUTPUT
   ;	l, w: semi-axes or standard deviation (see caller routine) of the
   ;		elliptical gaussian (l: semi-major axis, w: semi-minor axis)

   PRO ellipt_gau_lw, r, l1, l2, w1, w2, l, w

	l = ( l1 + l2 * r ) * r
	w = ( w1 + w2 * r ) * r
	return
   end
