   ; ELLIPT_GAUSSIAN: compute an elliptical gaussian.

   ; INPUT
   ;	sx, sy: x- and y- size of output image
   ;	xc, yc: center of gaussian
   ;	angle: angle between the major axis of the elliptical gaussian and
   ;		the x-axis of the image reference frame, measured in radians in
   ;		counter-clockwise sense
   ;	sigma_x, sigma_y: dispersion parameters of the gaussian
   ; OUTPUT
   ;	Return a sx * sy array containing the elliptical gaussian.
   ; NOTE
   ;	The gaussian, apart from the position of the center (xc,yc) and the
   ;	position angle with respect to the x-axis of the image reference frame,
   ;	is defined according to the formula
   ;	exp( -0.5*(x / sigma_x)^2 ) * exp( -0.5*(y / sigma_y)^2 ),
   ;	where sigma_x and sigma_y are the input dispersion parameters.


   FUNCTION ellipt_gaussian, sx, sy, xc, yc, angle, sigma_x, sigma_y

	min_sigma = 1e-2
	if  sigma_x lt min_sigma or sigma_y lt min_sigma  then begin
	   gaussian = fltarr( sx, sy )
	   gaussian[ round(xc), round(yc) ] = 1
	   return, gaussian
	endif
	x = findgen( sx ) - xc  &  y = findgen( sy ) - yc
	x = x # ( fltarr( sy ) + 1 )  &  y = ( fltarr( sx ) + 1 ) # y
	c = cos( angle )  &  s = sin( angle )
	xr = (  x * c + y * s ) / ( sqrt(2) * sigma_x )
	yr = ( -x * s + y * c ) / ( sqrt(2) * sigma_y )
	return, exp( -xr^2 ) * exp( -yr^2 )
   end
