   ; ELLIPT_GAUSSIAN: compute an elliptical gaussian.

   ; INPUT
   ;	sx, sy: x- and y- size of output image
   ;	xc, yc: center of gaussian
   ;	angle: angle between the major axis of the elliptical gaussian and
   ;		the x-axis of the image reference frame, measured in radians in
   ;		counter-clockwise sense
   ;	sigma_x, sigma_y: dispersion parameters of the gaussian
   ; OUTPUT
   ;	Return a sx * sy array containing the elliptical gaussian.
   ; NOTE
   ;	The gaussian, apart from the position of the center (xc,yc) and the
   ;	position angle with respect to the x-axis of the image reference frame,
   ;	is defined according to the formula
   ;	exp( -0.5*(x / sigma_x)^2 ) * exp( -0.5*(y / sigma_y)^2 ),
   ;	where sigma_x and sigma_y are the input dispersion parameters.



   ; ROTATED_AXIS: auxiliary function, used to compute a 'degenerate'
   ;	2-D gaussian, when one or both the dispersion parameters are
   ;	smaller than a lower threshold (default 1e-2).

   FUNCTION rotated_axis, sx, sy, xc, yc, angle

	if  abs( cos( angle ) ) lt 2*zero()  then begin
	   a = fltarr( sx, sy )  &  a[xc,*] = 1  &  return, a
	endif
	y = yc + tan( angle ) * ( findgen( sx ) - xc )
	x = lindgen( sx )  &  y = round( y )
	w = where( y ge 0  and  y lt sy, n )
	a = fltarr( sx, sy )
	if  n ne 0  then  a[x[w],y[w]] = 1
	return, a
   end

   FUNCTION ellipt_gaussian, sx, sy, xc, yc, angle, sigma_x, sigma_y

	min_sigma = 1e-2
	wx = sqrt(2) * sigma_x  &  wy = sqrt(2) * sigma_y
	x = findgen( sx ) - xc  &  y = findgen( sy ) - yc
	x = x # ( fltarr( sy ) + 1 )  &  y = ( fltarr( sx ) + 1 ) # y
	c = cos( angle )  &  s = sin( angle )
	if  sigma_x gt min_sigma  then begin
	   xr = (  x * c + y * s ) / wx  &  ex = exp( -xr^2 )
	endif else  ex = rotated_axis( sx, sy, xc, yc, angle + !pi/2 )
	if  sigma_y gt min_sigma  then begin
	   yr = ( -x * s + y * c ) / wy  &  ey = exp( -yr^2 )
	endif else  ey = rotated_axis( sx, sy, xc, yc, angle )
	return, ex * ey
   end
