   ; ESTIMATE_BACKGROUND: estimate image background by local sampling
   ; (with SKY) + spline interpolation (default) or by median smoothing.

   ; INPUT
   ;	image
   ;	step: box for median smoothing or background sampling
   ;	[/SKY_MEDIAN]: estimate background by median smoothing
   ;	[_EXTRA = ]: optional input parameters of IMAGE_BACKGROUND
   ; OUTPUT
   ;	Return background estimate (same size as image)

   FUNCTION estimate_background, image, step, SKY_MEDIAN = sky_median, $
   								 _EXTRA = extra

	if  keyword_set( sky_median )		 then $
   	   b = median_filter( image, step )  else $
	   b = image_background( image, step, _EXTRA = extra )
	return, b
   end

