   ; EXTEND_ARRAY: extend an array to a new size, by means of 0-padding.

   ; INPUT
   ;	array: array to be extended; it may be 1-D or 2D
   ;	s1, s2: sizes of extended array. If only s1 is supplied, then
   ;		s2 = s1 is assumed
   ;	[X_OFF = , Y_OFF = ]: x- and y- offset of the original
   ;		image into the extended one
   ; OUTPUT
   ;	Return extended array.
   ;	The input array is returned if it is neither 1-D nor 2-D
   ;	or if the specified output size is smaller than the input.

   FUNCTION extend_array, array, s1, s2, X_OFF = x, Y_OFF = y

	if  n_elements( x ) * n_elements( y ) eq 0  then begin
	   x = 0  &  y = 0
	endif
	s = mysize( array, /N_DIM )
	if  s gt 2  then  return, array
	if  s eq 2  then  ndim = 2  else  ndim = 1
	if  n_params() eq 2  then  s2 = s1
	type = mysize( array, /TYPE )  &  s = mysize( array, /DIM )  &  sx = s[0]
	if  ndim eq 2  then  sy = s[1]  else  sy = sx
	if  s1 lt sx or s2 lt sy  then  array1 = array $
	else if  ndim eq 1  then begin
	   array1 = make_array( s1, TYPE = type )	   &  array1[x] = array
	endif else begin
	   array1 = make_array( s1, s2, TYPE = type )  &  array1[x,y] = array
	endelse
	return, array1
   end