   ; EXTEND_POW2: extend array size to the nearest power of two.

   ; INPUT
   ;	array: 2-D array to be extended
   ; OUTPUT
   ;	Return extended array, centered in the final frame

   FUNCTION extend_pow2, array

    if  mysize( array, /N_DIM ) ne 2  then  return, array
    s = mysize( array, /DIM )  &  sx = s[0]  &  sy = s[1]
    if  2^log2( sx ) ne sx  then  sx = 2^( log2( sx ) + 1 )
    if  2^log2( sy ) ne sy  then  sy = 2^( log2( sy ) + 1 )
    ext_array = extend_array( array, sx, sy, $
    			X_OFF = ( sx - s[0] ) / 2, Y_OFF = ( sy - s[1] ) / 2 )
    return, ext_array
   end
