   ; EXTRACT: extract a box from an image, centered at (x,y).

   ; INPUT
   ;	image: 2-D image
   ;	bsize_x, [bsize_y]: x- and y- size of box to be extracted;
   ;		if bsize_x >= image size or bsize_y >= image size,
   ;		the input image is returned
   ;		If bsize_y is not supplied, it is assumed to be
   ;		bsize_y = bsize_x
   ;	[X = , Y = ]: central position of the box in the image
   ;		(default: image maximum)
   ; OUTPUT
   ;	Return box. Return the input image if the box bounds are outside
   ;	the image support or if the image is not 2-D
   ;	[LO_X = , etc.]: return subscritps defining the box in the image
   ; NOTE: the returned box is a (bsize_x * bsize_y) array if its bounds
   ;	are within the image support; otherwise the box sizes may be
   ;	different from the specified values.

   FUNCTION extract, image, bsize_x, bsize_y, X = x, Y = y, $
		    LO_X = lo_xi, UP_X = up_xi, LO_Y = lo_yi, UP_Y = up_yi

	if  mysize( image, /N_DIM ) ne 2  then  return, image
	s = mysize( image, /DIM )  &  sx = s[0]  &  sy = s[1]
	if  n_params() eq 2  then  bsize_y = bsize_x
	if  n_elements( x ) * n_elements( y ) eq 0  then begin
	   image_max = get_max( image )
	   x = image_max[0]  &  y = image_max[1]
	endif
	insert, fltarr( bsize_x, bsize_y ), image, $
			SSX = bsize_x, SSY = bsize_y, LSX = sx, LSY = sy,   $
			round( x ), round( y ), lo_xb, up_xb, lo_yb, up_yb, $
			lo_xi, up_xi, lo_yi, up_yi, out_of_range
	if  out_of_range  then $
	   box = image	  else $
	   box = image[lo_xi:up_xi,lo_yi:up_yi]
	return, box
   end
