   ; FWHM: estimate FWHM of a peak in a given image. Any strong background
   ; in the input image around the peak should be previously subtracted.

   ; INPUT
   ;	image
   ;	[X = , Y = ]: x- and y- position of peak (default: image maximum)
   ;	[PEAK_BOX = ]: size of box containing the peak (default = 15)
   ;	[_EXTRA = ]: optional input parameters of IMAGE_WIDTH
   ; OUTPUT
   ;	Return estimate of peak FWHM

   FUNCTION fwhm, image, X = x, Y = y, PEAK_BOX = peak_box, _EXTRA = extra

	if  n_elements( x ) * n_elements( y ) eq 0  then begin
	   m = get_max( image )  &  x = m[0]  &  y = m[1]
	endif
	if  n_elements( peak_box ) eq 0  then peak_box = 15
	peak = extract( image, peak_box, X = x, Y = y, LO_X = lx, LO_Y = ly )
	x_peak = x - lx  &  y_peak = y - ly
	return, image_width( peak, X = x_peak, Y = y_peak, _EXTRA = extra )
   end