   ; GAUSSIAN_KER_SIZE: auxiliay function, compute optimal gaussian
   ; kernel size.
   ; INPUT
   ;	sigma1, sigma2: dispersion parameters of gaussian
   ;	angle: position angle of axis 1
   ;	[N_SIGMA = ]: the gaussian is truncated at
   ;		N_SIGMA * max[ sigma1, sigma2 ]; default = 3
   ; OUTPUT
   ;	Return 2-element vector

   FUNCTION gaussian_ker_size, sigma1, sigma2, angle, N_SIGMA = n_sigma

	if  n_elements( n_sigma ) eq 0  then  n_sigma = 3
	c = abs( cos( angle ) )  &  s = abs( sin( angle ) )
	ker_size = [ max( [sigma1 * c, sigma2 * s] ), $
				 max( [sigma1 * s, sigma2 * c] )    ]
	ker_size = ( 2 * n_sigma * round( ker_size ) + 1 ) > 3
	return, ker_size
   end
