   ; GAUSSIAN_NOISE: estimate standard deviation of gaussian noise
   ; in a given image.

   ; ALGORITHM DESCRIPTION: see
   ; Almoznino, Loinger, Brosch, 'Calculation of background in images',
   ; MNRAS, 254, 641 (1993)


   PRO intensity_range, data, NPIX = npix, range, minval, maxval

	if  n_elements( npix ) eq 0  then  npix = 1000
	ndata = n_elements( data )
	pix = round( randomu( seed, npix < ndata ) * ( ndata - 1 ) )
	subs_to_coord, pix, ( mysize( data, /DIM ) )[0], xpix, ypix
	pix = data[xpix,ypix]  &  m = median( pix )
	range = 4 * sqrt( ( moment( pix - m ) )[1] )
	minval = m - range / 2  &  maxval = m + range / 2
	minval = minval > min( data )  &  maxval = maxval < max ( data )
    return
   end

   FUNCTION init_number_bins, data, range, minval, maxval

	incr = 1.5  &  nbin = 8 / incr  &  max_nbin = 2048
	repeat begin
	   nbin = round( nbin * incr )  &  binsize = range / nbin
	   h = histogram( data, BINSIZE = binsize, MIN = minval, MAX = maxval )
	   m = max( h, w )
	   l = w  &  while  h[l] gt m / 2  do  l = l - 1
	   r = w  &  while  h[r] gt m / 2  do  r = r + 1
	   l = l > 0  &  r = r < n_elements( h ) - 1
	   nbin_fwhm = r - l + 1
	endrep until  nbin gt max_nbin or nbin_fwhm ge 5
	return, nbin
   end

   FUNCTION gaussian_noise, image

	; Subtract median
	if  n_elements( patch_size ) eq 0  then  patch_size = 3
	residual = image - median_filter( image, patch_size )
	; Find intensity range
	intensity_range, residual, _EXTRA = extra, range, minval, maxval
	; Set initial number of bins
	nbin = init_number_bins( residual, range, minval, maxval )
	; Determine standard deviation of gaussian noise by gaussian fitting

	return, std
   end