   ; GET_MAX: search for the maximum intensity pixel of a 2-D image.

   ; INPUT
   ;	image
   ; OUTPUT
   ;	Return a 2-elements long integer vector [x,y], where x and y are
   ;	the components of the image maximum. If the image is not 2-D, a
   ;	negative scalar is returned.

   FUNCTION get_max, image

	s = mysize( image )
	if  s[0] ne 2  then  return, -1
	s = s[1]
	m = max( image, index )  &  subs_to_coord, index, s, x, y
	return, [ x, y ]
   end
