pro getfits_ext,file_or_fcb

; get number of extension in fits file

 compile_opt idl2

; Open file if file name is supplied
;
        fcbtype = size(file_or_fcb,/type)
        fcbsize = n_elements(file_or_fcb)
        if (fcbsize ne 1) or ((fcbtype ne 7) and (fcbtype ne 8)) then begin
                message, 'Invalid Filename or FCB supplied',/con
                return
        end

        if fcbtype eq 7 then fits_open,file_or_fcb,fcb $
                        else fcb = file_or_fcb

print,'toto',fcb.nextend
; EXTNAME will always be displayed with a length of at least 10 characters
; but allow for possibility that lengths might be longer than this

        maxlen = max(strlen(fcb.extname)) > 10
        if maxlen EQ 10 then space = '' else $
            space = string(replicate(32b, maxlen -10))
;
; print headings
;
        print,' '
        print,FCB.FILENAME
        print,' '
        print,'     XTENSION  EXTNAME  '+ space + $
              'EXTVER EXTLEVEL BITPIX GCOUNT  PCOUNT NAXIS  NAXIS*'
        print,' '
;
; loop on extensions
;
        for i=0,fcb.nextend do begin
                st = string(i,'(I4)')
;
; xtension, extname, extver, extlevel (except for i=0)
;
                if i gt 0 then begin
                        t = fcb.xtension[i]
                        while strlen(t) lt 8 do t = t + ' '
                        st = st + ' '+ strmid(t,0,8)
                        t = fcb.extname[i]
                        while strlen(t) lt maxlen do t = t + ' '
                        st = st + ' '+ strmid(t,0,maxlen)
                        t = fcb.extver[i]
                        if t eq 0 then st = st + '     ' $
                                  else st = st + string(t,'(I5)')
                        t = fcb.extlevel[i]
                        if t eq 0 then st = st + '        ' $
                                  else st = st + string(t,'(I8)')
                end else st = st + '                                 ' + space
;
; bitpix, gcount, pcount, naxis
;
                st = st + string(fcb.bitpix[i],'(I6)')
                st = st + string(fcb.gcount[i],'(I7)')
                st = st + string(fcb.pcount[i],'(I7)')
                st = st + string(fcb.naxis[i],'(I6)')
;
; naxis*
;
                st = st + '  '
                if fcb.naxis[i] gt 0 then begin
                    nax1 = fcb.naxis[i] - 1
                    st = st + strjoin(strtrim(fcb.axis[0:nax1,i],2),' x ')
                endif
;
; print the info
;
                print,st
        end
        if fcbtype eq 7 then fits_close,fcb
return
end
