   ; GOLDEN_SECTION: find the minimum of the unimodal function f(x(alfa)) along
   ;	the segment		x(alfa) = (1 - alfa) * a + alfa * b, for 0 <= alfa <= 1

   ; INPUT
   ;	a0, b0: extremes of the segment
   ;	fa0, fb0: f(x(alfa = 0)) and f(x(alfa = 1))
   ;	f_fun: name of a function to compute f(x), defined as
   ;		FUNCTION f_fun, x [, KEYWORD_1 = , ..., KEYWORD_N = ],
   ;		where the keyword parameters may be either by value of by reference
   ;	[X_FUN = x_fun]: name of an auxiliary function required by f_fun to
   ;		compute f(x(alfa)). If x_fun is set, the input argument for f_fun
   ;		must be equal to the output of x_fun. It must be defined as
   ;		FUNCTION x_fun, x [, KEYWORD_1 = , ..., KEYWORD_N = ],
   ;		where the keyword parameters may be either by value of by reference
   ;	[CONVERG_FUN = converg_fun]: name of an auxiliary function to check the
   ;		stopping condition for golden section search, defined as
   ;		FUNCTION converg_fun, a, b [, KEYWORD_1 = , ..., KEYWORD_N = ],
   ;		where the keyword parameters may be either by value of by reference
   ;	[_REF_EXTRA = extra]: optional parameters of f_fun, x_fun, converg_fun
   ; OUTPUT
   ;	x: point on the segment [a,b] corresponding to the minimum of f(x(alfa))
   ;	fx: value of f at minimum
   ;	[MIN_X_FUN = min_x_fun]: value of x_fun at minimum
   ;		Active only if [X_FUN = x_fun] is set.





   ; COMPUTE_POINT: compute left or right point for golden section search.

   PRO compute_point, p0, step_size, direction, f_fun, X_FUN = x_fun, $
   					  _REF_EXTRA = extra, p, fp

	p = p0 + step_size * direction
	if  n_elements( x_fun ) ne 0  then $
	   temp = call_function( x_fun, p, _EXTRA = extra ) $
	else  temp = p
	fp = call_function( f_fun, temp, _EXTRA = extra )
	return
   end

   ; DEFAULT_CONV: default stopping criterion for golden section search.

   FUNCTION default_conv, a, b, _EXTRA = extra

	common	converg, alfa, min_alfa

	return, alfa le min_alfa
   end



   PRO golden_section, a0, b0, fa0, fb0, f_fun, X_FUN = x_fun, $
   					   CONVERG_FUN = converg_fun, _REF_EXTRA = extra, $
   					   x, fx, MIN_X_FUN = min_x_fun

	common	converg, alfa, min_alfa

	if  n_elements( converg_fun ) eq 0  then begin
	   converg_fun = 'default_conv'  &  min_alfa = 5.e-4
	endif
	a = a0  &  b = b0  &  fa = fa0  &  fb = fb0
	golden_sect = 2 / (1 + sqrt(5))
	d = b - a  &  alfa = 1.
	left = 1B  &  right = 1B
	while  not call_function( converg_fun, a, b, _EXTRA = extra )  do begin
	   alfa = golden_sect * alfa
	   if  left   then $
	      compute_point, b, -alfa, d, f_fun, X_FUN = x_fun, $
	      				 _EXTRA = extra, l, fl
	   if  right  then $
	      compute_point, a, +alfa, d, f_fun, X_FUN = x_fun, $
	      				 _EXTRA = extra, r, fr
	   if  fl lt fr  then begin
	      b = r  &  r = l  &  fb = fr  &  fr = fl
	      left = 1B  &  right = 0B ; Next step: evaluate left point
	   endif else begin
	      a = l  &  l = r  &  fa = fl  &  fl = fr
	      left = 0B  &  right = 1B ; Next step: evaluate right point
	   endelse
	endwhile
	if  fl lt fr  then begin  x = l  &  fx = fl
	endif else begin		  x = r  &  fx = fr  &  endelse
	if  n_elements( x_fun ) ne 0  then $
	   min_x_fun = call_function( x_fun, x, _EXTRA = extra )
	return
   end
