   ; HISTO: compute data histogram with a pre-fixed bin size and
   ;	within a specified range of data values.
   ;	To display the histogram, type
   ;	IDL> plot, x, h, PSYM = 10

   ; INPUT
   ;	data: input data
   ;	dmin, dmax: min and max data values for histogram computation
   ;	bin: size of bin
   ; OUTPUT
   ;	x: data values corresponding to center of bins
   ;	h: histogram

   PRO histo, data, dmin, dmax, bin, x, h

	range = float( dmax - dmin )  &  nbin = long( range/bin ) + 1
	x = findgen( nbin ) * bin + dmin + bin/2.
	h = histogram( float( data ), BINSIZE = bin, $
				   MIN = float( dmin ), MAX = float( dmax ) )
	n = min( [ n_elements( x ), n_elements( h ) ] )
	x = x[0:n-1]  &  h = h[0:n-1]
   return
  end
