   ; IMAGE_AREA: given an image containing a spike (by default the image
   ;	maximum), estimate the spike area at a given level below the peak.
   ;	NOTE: the background is assumed to be zero. Any strong background
   ;	contribution may affect the result.

   ; ALGORITHM DESCRIPTION
   ;	Use connected component extraction and thresholding to label the
   ;	region surrounding the spike. The labeled region area (in pixels)
   ;	is then measured.

   ; INPUT
   ;	image: image to be measured
   ;	[X = , Y = ]: central position of the spike
   ;		(default = image maximum)
   ;	[REL_THRESHOLD = ]: relative value below the peak of the spike to
   ;		be used as a threshold for image transformation
   ;		(default = 0.5 ==> area at half maximum)
   ;	[MAG = ]: magnification factor for spline interpolation. If the
   ;		image is rebinned by oversampling the area estimate is more
   ;		accurate. Odd magnification factors should be preferred
   ;		(default = 3)

   FUNCTION image_area, image, MAG = mag, X = x, Y = y, REL_THRESHOLD = rt

	if  n_elements( mag ) eq 0  then  mag = 3  &  mag = round( mag ) > 1
	if  n_elements( x ) * n_elements( y ) eq 0  then begin
	   m = get_max( image )  &  x = m[0]  &  y = m[1]
	endif
	if  n_elements( rt ) eq 0  then  rt = 0.5
	; Image magnification
	i = image ;- min( image )
	i = spline_magnify( i, mag, mag, error ) > 0
	if  error  then  m = 1  else  m = mag
	xm = x * m + ( m - 1 ) / 2  &  ym = y * m + ( m - 1 ) / 2
	; Thresholding and central component extraction
	i = binary_image( i, rt * i[xm,ym] )
	i = image_core( float( i ), 0.5, X = xm, Y = ym )
	; Compute area
	return, total( float( i ) ) / float( m )^2
   end
