   ; IMAGE_CORE: find the connected component of an image around a
   ;	pre-fixed position (default image maximum) and above a fixed
   ;	threshold, by means of SEARCH2D.

   ; INPUT
   ;	image
   ;	[X = , Y = ]: seed position to search for the connected component
   ;		(default = image maximum)
   ;	threshold: threshold for central connected component extraction
   ;	[/SUBTRACT]: subtract threshold from extracted connected component
   ; OUTPUT
   ;	Return an image containing the central connected component of the
   ;	input image (same size as input)

   FUNCTION image_core, image, X = x, Y = y, $
   						threshold, SUBTRACT = subtract

	if  mysize( image, /N_DIM ) ne 2  then  return, image
	s = mysize( image, /DIM )  &  s = s[0]
	if  n_elements( x ) * n_elements( y ) eq 0  then begin
	   m = get_max( image )  &  x = m[0]  &  y = m[1]
	endif
	if  threshold eq image[x,y]  then  return, image
	w = search2d( image, x, y, threshold, max( image ) )
	ccc = image - image  &  ccc[w] = image[w]
	if  keyword_set( subtract )  then  ccc[w] = ccc[w] - threshold
	return, ccc
   end
