   ; IMAGE_WIDTH: given an image containing a spike (by default the image
   ;	maximum) estimate the spike width at a given level below the peak
   ;	(default FWHM). The width is estimated as the diameter of a circle
   ;	having the same area (computed by IMAGE_AREA) as the spike.

   ; INPUT
   ;	image: image to be measured
   ;	[_EXTRA = ]: optional input parameters of IMAGE_AREA
   ; OUTPUT
   ;	Return spike width (default FWHM)

   FUNCTION image_width, image, _EXTRA = extra

	return, sqrt( 4 * image_area( image, _EXTRA = extra ) / !pi  )
   end
