   ; INSERT: given an array small_im[ssx,ssy] and a larger one
   ;	large_im[lsx,lsy], insert the small array into the larger one,
   ;	so that pixel (xs,ys) of the latter coincides with pixel (xl,yl)
   ;	of the former.

   ; INPUT
   ;	small_im, large_im: arrays
   ;	[SSX = , ..., LSX = , ...]: small_im and large_im sizes
   ;	[XS = , YS = ]: reference pixel of small image
   ;		( default = (ssx/2,ssy/2) )
   ;	xl, yl: pixel position of large_im where reference pixel (xs,ys)
   ;		of small_im must be centered
   ; OUTPUT
   ;	lo_xs, up_xs, ..., lo_xl, up_xl, ...: lower and upper subscript
   ;		bounds  for insertion of small_im into large_im
   ;	out_of_range: boolean, true if some error occurs in the insertion;
   ;		if out_of_range = true, the insertion will cause a 'subscript
   ;		out of range' run-time error

   PRO insert, small_im, large_im,									 $
   			   SSX = ssx, SSY = ssy, LSX = lsx, LSY = lsy,			 $
   			   XS = xs, YS = ys, xl, yl, lo_xs, up_xs, lo_ys, up_ys, $
   			   lo_xl, up_xl, lo_yl, up_yl, out_of_range

	if  n_elements( ssx ) * n_elements( ssy ) eq 0  then begin
	   s = mysize( small_im, /DIM )  &  ssx = s[0]  &  ssy = s[1]
	endif
	if  n_elements( lsx ) * n_elements( lsy ) eq 0  then begin
	   s = mysize( large_im, /DIM )  &  lsx = s[0]  &  lsy = s[1]
	endif
	if  n_elements( xs ) * n_elements( ys ) eq 0  then begin
	   xs = ssx / 2  &  ys = ssy / 2
	endif
	; Define lower and upper bounds to insert small_im into large_im
	lo_xl = xl - xs  &  up_xl = lo_xl + ssx - 1
	lo_yl = yl - ys  &  up_yl = lo_yl + ssy - 1
	lo_xs = 0  &  up_xs = ssx - 1  &  lo_ys = 0  &  up_ys = ssy - 1
	; Check bounds
	d = lo_xl < 0					 &  lo_xl = lo_xl - d  &  lo_xs = lo_xs - d
	d = (lsx-1) - ( up_xl>(lsx-1) )  &  up_xl = up_xl + d  &  up_xs = up_xs + d
	d = lo_yl < 0					 &  lo_yl = lo_yl - d  &  lo_ys = lo_ys - d
	d = (lsy-1) - ( up_yl>(lsy-1) )  &  up_yl = up_yl + d  &  up_ys = up_ys + d
	out_of_range = up_xl lt lo_xl or up_yl lt lo_yl or $
				   up_xs lt lo_xs or up_ys lt lo_ys
	return
   end