; Solves the linear equation system Ax=b in least square sens

PRO least_square, A, b, x


SVDC, A, W, U, V          ;Compute the singular value decomposition of A.


N = N_ELEMENTS(W)

WP = FLTARR(N, N)

FOR K = 0, N-1 DO BEGIN
  IF ABS(W(K)) GE 1.0e-5 THEN WP(K, K) = 1.0/W(K)
ENDFOR

x = V ## WP ## TRANSPOSE(U) ## b

END

