; $Id: lecture_haso.pro,v 1.3 2002-05-22 16:07:00+02 lrousset Exp $ ;

;+
;NOM :
;   LECTURE_HASO - Lecture des donnes pentes et/ou intensits du HASO
;
;CATEGORIE :
;   Input/Output Routines
;
;SYNTAXE :
;   lecture_haso ,
;           fichier, [dpx=dpy], [dpy=dpy], [pupille=pupille],
;           [intensite=intensite], [/VERBOSE], [/VERSION], [/HELP]
;
;DESCRIPTION :
;   Cette fonction permet de lire les donnes de type ".has" enregistre par
;   le logicile HASO. Les donnes ".has" contiennent les mesures des pentes en
;   x, en y, la pupille valide et les intensits.
;   Le logiciel HASO enregistre au format ASCII les pentes, intensits ainsi
;   que le masque de sous-pupille valide sous forme de bloc de 64x64 lments
;   (le nombre de sous-pupilles de l'instrument est de 64x64).
;   Cette fonction retourne donc des tableaux 64x64 contenant les valeurs
;   enregistres. Pour une bonne utilisation, ne pas oublier le masque des
;   sous-pupilles valides.
;
;   ATTENTION : les sous-pupilles valides (appeles calculable par HASO) ne
;               sont pas forcement les mmes que celles dfinies par
;               l'utilisateur. Il peut y en avoir moins...
;
;   ARGUMENTS :
;
;   fichier   : (entre) Nom du fichier HASO  lire.
;
;   dpx       : (sortie) contient les pentes en x.
;
;   dpy       : (sortie) contient les pentes en y.
;
;   pupille   : (sortie) contient le masque des sous-pupilles valides.
;
;   intensite : (sortie) contient les intensits mesures.
;
;   /VERBOSE  : (entre) affichage de messages durant l'excution.
;
;   /VERSION  : (entre) affichage de la version avant l'excution.
;
;   /HELP     : (entre) affichage de la syntaxe et sortie du programme.
;
;DIAGNOSTIC D'ERREUR :
;
;
;VOIR AUSSI :
;
;
;AUTEUR :
;   $Author: lrousset $
;
;HISTORIQUE :
;   $Log: lecture_haso.pro,v $
;   Revision 1.3  2002-05-22 16:07:00+02  lrousset
;   coorection erreur syntaxe de documentation
;
;
;   Revision 1.1  2002-05-22 11:54:46+02  lrousset
;   Initial revision
;
;-

PRO lecture_haso2,  fichier, dpx = dpx, dpy = dpy, intensite = intensite, pupille= pupille

on_error,2

; lecture des fichiers HASO

; matrices des valeurs : les fichiers contiennent obligatoirement 64x64
;                        sous-pupilles.

sspupx = 64
sspupy = 64

dpx = fltarr(sspupx, sspupy)
dpy = fltarr(sspupx, sspupy)
pupille = fltarr(sspupx, sspupy)
intensite = fltarr(sspupx, sspupy)

; il y a 7 lignes de texte en entte.
entete = 7

IF keyword_set(verbose) THEN print,  'Lecture du fichier : ',  fichier


; lecture fichier :
line1 = ' '
line2 = ' '

openr, unit, fichier, /get_lun

;lecture en tete des fichiers

for i=0,entete-1 do BEGIN
    readf, unit,  format = '(2(A))',  line1,  line2
    l = line1 + line2
ENDFOR

;lecture de la ligne "pentes en X (mrad)"
readf, unit, format = '(2(A))',  line1,   line2

for i=0, sspupy-1 do BEGIN
    readf, unit,  format = '(2(A))',  line1,  line2
    l = line1 + line2
    l=strjoin(strsplit(l,',',/extract),'.')
    string_array = str_sep(strcompress(l), ' ')
    dpx[*, i]= float(string_array[*])
ENDFOR

;lecture de la ligne "pentes en y (mrad)"
readf, unit, format = '(2(A))',  line1,   line2

;lecture des pentes en y

for j=0,sspupy-1 do BEGIN
    readf, unit,  format = '(2(A))',  line1,  line2
    l = line1 + line2
    l=strjoin(strsplit(l,',',/extract),'.')
    string_array = str_sep(strcompress(l), ' ')
    dpy[*, j] =float(string_array[*])
ENDFOR

;lecture de la ligne "Sous-pupilles calculables"
readf, unit, format = '(2(A))',  line1,  line2

;lecture du masque de sous-pupilles valides

for k=0,sspupy-1 do BEGIN
    readf, unit, format = '(2(A))',  line1,  line2
    l = line1+line2
    string_array = str_sep(strcompress(l), ' ')
    pupille(*, k) =float(string_array(*))
ENDFOR

;lecture de la ligne "intensit"
readf, unit, format = '(2(A))',  line1,  line2

;lecture des intensits

for k=0,sspupy-1 do BEGIN
    readf, unit, format = '(2(A))',  line1,  line2
    l = line1+line2
    string_array = str_sep(strcompress(l), ' ')
    intensite(*, k) =float(string_array(*))
ENDFOR

close, unit
free_lun, unit

dpx = pupille*dpx
dpy = pupille*dpy
intensite = pupille*intensite

END

