   ; LOCAL_MAX: find the local maxima within a 2-D image above a threshold,
   ;	by means of ALL_MAX.

   ; INPUT
   ;	image
   ;	threshold: lower value for detection
   ;	[X0 = x0, Y0 = y0]: reference position (see keywords below)
   ;		(default = central pixel of image)
   ;	[MAX_DIST = max_dist]: maximum distance (in pixels) of detected
   ;		maxima from (x0,y0)
   ;	[/NEAREST]: among the detected maxima, select the nearest to (x0,y0)
   ;	[/MAXIMUM]: among the detected maxima, select the brightest one
   ;	NOTE. The 3 checks above are performed in the same order they are
   ;		presented; of course it is not possible to select the nearest and
   ;		brightest maximum...
   ; OUTPUT
   ;	Return 'true' if at least one maximum has been detected
   ;	x, y: positions of local maxima

   FUNCTION local_max, image, threshold, X0 = x0, Y0 = y0, $
   				MAX_DIST = max_dist, NEAREST = nearest, MAXIMUM = maximum, x, y

	check_dist = n_elements( max_dist ) ne 0
	select_nearest  = keyword_set( nearest )
	select_maximum  = keyword_set( maximum )
	all_max, image, SX = sx, SY = sy, threshold, x, y, i, n
	check = n ne 0
	if  check  then begin
	   if  check_dist or select_nearest then begin
	      if  n_elements( x0 ) * n_elements( y0 ) eq 0  then begin
		     x0 = sx / 2  &  y0 = sy / 2
	      endif
	      d = distance( x, y, x0, y0 )
	      if  check_dist  then begin
	         w = where( d le max_dist, n )
	         check = n ne 0
	         if  check  then begin
	            d = d[w]  &  x = x[w]  &  y = y[w]  &  i = i[w]
	         endif
	      endif
	      if  check and select_nearest  then begin
	         m = min( d, w )  &  x = x[w]  &  y = y[w]  &  i = i[w]
	      endif
	   endif
	   if  check and select_maximum  then begin
	      m = max( i, w )  &  x = x[w]  &  y = y[w]
	   endif
	endif
	return, check
   end
