   ; LS_SYS: least squares form of an algebraic linear system.

   ; ALGORITHM DESCRIPTION: transform the linear system  ax = b to its
   ;		least squares form  (a'a)x = a'b, where a' is the transpose
   ;		of a.

   ; INPUT
   ;	a, b (unchanged on output)
   ;	[WEIGHTS = ]: (squared) weighting factors on b
   ;	[MASK = ]: subscripts of bad points to be excluded
   ; OUTPUT
   ;	a_ls = a'a
   ;	b_ls = a'b


   PRO ls_sys, a, b, WEIGHTS = w, MASK = pix, a_ls, b_ls

	if  mysize( a, /N_DIM ) ne 2 or mysize( b, /N_DIM ) ne 1  then  return
	s = mysize( a, /DIM )  &  n_col = s[0]  &  n_rows = s[1]
	a_ls = transpose( a )
	if  n_elements( w ) ne 0 or n_elements( pix ) ne 0  then begin
	   m = fltarr( n_rows, n_rows )  &  diag = lindgen( n_rows )
	endif
	if  n_elements( w ) ne 0  then begin
	   m[diag,diag] = w  &  a_ls = m # a_ls
	endif
	if  n_elements( pix ) ne 0  then  if  pix[0] ge 0  then begin
	   m[diag,diag] = 1  &  m[diag[pix],diag[pix]] = 0  &  a_ls = m # a_ls
	endif
	if  n_col gt 1  then  b_ls = b # a_ls  else  b_ls = total( b * a_ls )
	a_ls = a # a_ls
	return
   end
