   ; MASK_PIXELS: mask data[pixels] with a pre-fixed value.

   ; INPUT
   ;	data: data array (of any valid dimension)
   ;	pixels: array of subscripts identifying the pixels to be masked
   ;	[VALUE = ]: value of masked pixels (default = 0)
   ; OUTPUT
   ;	Return data with masked pixels

   FUNCTION mask_pixels, data, pixels, VALUE = v

	if  n_params() eq 1 or n_elements( pixels ) eq 0  then  return, data
	if  n_elements( v ) eq 0  then  v = 0
	if  pixels[0] eq -1  then  masked_data = data $
	else begin
	   masked_data = data  &  masked_data[pixels] = v
	endelse
	return, masked_data
   end
