   ; MEDIAN_FILTER: image smoothing by median filtering on a variable size
   ;	neighborhood (equivalent to IDL MEDIAN in the inner part of the
   ;	image).

   ; INPUT
   ;	image: image to be smoothed
   ;	box: maximum width of square box to compute median (< image size)
   ;		If box is even, a size of box + 1 will be considered
   ; OUTPUT
   ;	Return median filtered image. Return the input image if the box
   ;	size is 1 or larger than the image size.
   ; NOTE: The image border (of width box/2), left unchanged by MEDIAN,
   ;	is filtered on an asymmetric neighborhood of reduced size. The
   ;	box size increases from box/2 at the image edge up to the supplied
   ;	value at a distance of box/2 from the edge itself.

   FUNCTION median_filter, image, box

	if  mysize( image, /N_DIM ) ne 2  then  return, image
	s = mysize( image, /DIM )  &  sx = s[0]  &  sy = s[1]
	if  box le 1 or box ge min( s )  then  return, image
	j = lindgen( sx )  &  i = lindgen( sy )  &  w = box / 2
	lo_j = ( j - w ) > 0  &  up_j = ( j + w ) < ( sx - 1 )
	lo_i = ( i - w ) > 0  &  up_i = ( i + w ) < ( sy - 1 )
	filtered = median( image, 2*w + 1 )
	for  i = 0, w - 1  do  for  j = 0, sx - 1  do $
	   filtered[j,i] = median( image[ lo_j[j]:up_j[j],lo_i[i]:up_i[i] ] )
	for  i = sy - w, sy - 1  do  for  j = 0, sx - 1  do $
	   filtered[j,i] = median( image[ lo_j[j]:up_j[j],lo_i[i]:up_i[i] ] )
	for  i = w, sy - w - 1  do  for  j = 0, w - 1  do $
	   filtered[j,i] = median( image[ lo_j[j]:up_j[j],lo_i[i]:up_i[i] ] )
	for  i = w, sy - w - 1  do  for  j = sx - w, sx - 1  do $
	   filtered[j,i] = median( image[ lo_j[j]:up_j[j],lo_i[i]:up_i[i] ] )
	return, filtered
   end
