;NAME:
;	MICROSHAPE

;AUTHOR
;Tordo Sebastien

;PURPOSE:
; 	Read data files created by mshape software Version 3.0

;CALLING SEQUENCE:
;	microshape,filename,image,comment,no_graph=no_graph

;INPUT:
;	FILENAME - Path + Name of the mshape file.
	 
;OPTIONAL OUTPUT:   
;	IMAGE - array of value scaled in 
;			Nanometers : for Wavefront Abberation maps   
;			2 Pi :       for Raw phase data maps
;			Gray Scale : for live intensity camera images		
;	COMMENT - string of comments attached to the input file 

;OPTIONAL KEYWORD:
;	NO_GRAPH - Avoid Graph display.


FUNCTION conv, in
in=fix(in)
out=in(0)+in(1)*255+in(2)*255^2+in(3)*255^3
return,out
end

PRO microshape, file,image,comment,no_graph=no_graph

openr,lun,file,/get_lun
msformat0=assoc(lun,bytarr(17))
msformat=msformat0(0)
xsize=msformat(1:4) & ysize=msformat(5:8) & zero=msformat(9:12)
comsize=msformat(13:16)
xsize=conv(xsize) & ysize=conv(ysize) & comsize=conv(comsize)
zero=conv(zero)

if comsize NE 0 then begin
a0=bytarr(1) & a1=bytarr(4) & a2=bytarr(4) & a3=bytarr(4) & a4=bytarr(4)
a5=bytarr(comsize) & a6=bytarr(4,xsize*ysize)
data0={id:a0,xs:a1,ys:a2,ap:a3,cs:a4,com:a5,dat:a6}
endif else begin 
a0=bytarr(1) & a1=bytarr(4) & a2=bytarr(4) & a3=bytarr(4) & a4=bytarr(4)
a6=bytarr(4,xsize*ysize)
data0={id:a0,xs:a1,ys:a2,ap:a3,cs:a4,dat:a6}
comment='NO COMMENT'
endelse


data=assoc(lun,data0)
temp=data(0)
array=temp.dat

if comsize NE 0 then comment=string(temp.com)

image=intarr(xsize,ysize)
for i=0,xsize*ysize-1 do image(i)=conv(array(*,i))
bad=where(image EQ zero)
;if bad(0) NE (-1) then image(bad)=min(image(where(image NE zero))) 
if bad(0) NE (-1) then image(bad)=0
if temp.id NE 3 then begin 
   image=reverse(image,2)/10.
   y='nanometers'
endif else image=reverse(image,2)/1024.

case temp.id of
1: t='Surface deviations (nm)'
2: t='Wavefront Aberration (nm)'
3: t='Raw phase (2.Pi)'
4: t='Live camera intensity (gray values)'
else : print,'Unknown data type'
endcase
 x='X axis (pixels)' & y='Y axis (pixels)'

if NOT keyword_set(no_graph) then begin
print,''
print,'COMMENT  : '+comment
print,'DATA TYPE: '+t
print,''

window,0,xs=165*3,ys=165*3,title=t
tvscl,congrid(image,165*3,165*3)
;window,1,xs=165*3,ys=165*3,title='3D View'
;shade_surf,image,title=t,xtitle=x,ytitle=y,ztitle=t,xcharsize=1.,$
;ycharsize=1.,zcharsize=1.,charsize=1.5,zstyle=1,xstyle=1,ystyle=1
endif

return
end





 
