   ; MIN_NORM_INVERSION: compute the minimum norm solution of the linear
   ;	algebraic system  ax = b. The matrix a is inverted by GINV.

   ; INPUT
   ;	a: n*m array (n columns, m rows)
   ;	b: m-components vector
   ; OUTPUT
   ;	Return a n-components vector.
   ;	The type of the result is:
   ;		double precision, if a is a double precision array
   ;		single precision, otherwise
   ;	The inversion of a is performed in double precision arithmetics.

   FUNCTION min_norm_inversion, a, b

	if  n_elements( a ) eq 1  then $
	   if  a[0] ne 0  then  return, b / a  else  return, 0
	s = mysize( a, /DIM )  &  n = s[0]  &  m = s[1]
	if  m ne n_elements( b )  then  return, 0
	return, b # ginv( a )
   end
