   ; MINIFY: down-sample a 2-D array by means of IDL REBIN
   ;	(with nearest neighbor averaging).

   ; INPUT
   ;	array: 2-D array to be down-sampled
   ;	x_minification:   x- minification factor (integer)
   ;	[y_minification]: y- minification factor (integer)
   ;		(default = x_minification)
   ; OUTPUT
   ;	Return minified array
   ; NOTE: if the array sizes are not multiple integers of minification
   ;	   factors, the array is padded with 0s to allow re-sampling by REBIN.
   ;	   Additional rows and columns are appended to the last row and column
   ;	   of the input array.

   FUNCTION minify, array, x_minification, y_minification

	if  mysize( array, /N_DIM ) ne 2  then  return, array
	mx = fix( x_minification )
	if  n_params() eq 3  then $
	   my = fix( y_minification )  else  my = mx
	s = mysize( array, /DIM )  &  sx = s[0]  &  sy = s[1]
	if  sx mod mx ne 0  then  sx = mx * ( sx / mx + 1 )
	if  sy mod my ne 0  then  sy = my * ( sy / my + 1 )
	return, rebin( extend_array( array, sx, sy ), sx / mx, sy / my )
   end
